function residual = dynamic_resid(T, y, x, params, steady_state, it_, T_flag)
% function residual = dynamic_resid(T, y, x, params, steady_state, it_, T_flag)
%
% File created by Dynare Preprocessor from .mod file
%
% Inputs:
%   T             [#temp variables by 1]     double   vector of temporary terms to be filled by function
%   y             [#dynamic variables by 1]  double   vector of endogenous variables in the order stored
%                                                     in M_.lead_lag_incidence; see the Manual
%   x             [nperiods by M_.exo_nbr]   double   matrix of exogenous variables (in declaration order)
%                                                     for all simulation periods
%   steady_state  [M_.endo_nbr by 1]         double   vector of steady state values
%   params        [M_.param_nbr by 1]        double   vector of parameter values in declaration order
%   it_           scalar                     double   time period for exogenous variables for which
%                                                     to evaluate the model
%   T_flag        boolean                    boolean  flag saying whether or not to calculate temporary terms
%
% Output:
%   residual
%

if T_flag
    T = World_Economy_Cartel_cost_inv_shocks.dynamic_resid_tt(T, y, x, params, steady_state, it_);
end
residual = zeros(76, 1);
residual(1) = T(35)+T(38)+params(32)*y(135)-y(89);
residual(2) = T(29)*(-T(22))+y(79)*(-(T(34)*params(4)*exp(y(31)*params(4))))+T(22)*y(69)+params(32)*y(137)-y(91);
residual(3) = y(78)*(-(T(32)*params(4)*exp(y(32)*params(4))))+y(74)*y(43)*T(32)*params(4)*(params(4)-1)*exp(y(32)*(params(4)-1))+T(39)+params(32)*y(136)-y(90);
residual(4) = T(29)*T(41)+y(82)*(-exp(y(33)))+exp(y(33))*y(81)+params(32)*y(139)-y(93);
residual(5) = y(82)*(-exp(y(34)))+exp(y(34))*y(80)+params(32)*y(138)-y(92);
residual(6) = T(43);
residual(7) = T(46);
residual(8) = T(47);
residual(9) = T(48);
residual(10) = T(50)+params(32)*(-exp(y(39)))*y(134);
residual(11) = T(45)+T(52)+T(54)+T(55)+T(56);
residual(12) = exp(y(41))*y(68);
residual(13) = y(73)*(-params(7))+y(72)+T(36)*y(22)*(-(T(27)*(1-exp(y(11)))))+T(36)*T(27)*y(24);
residual(14) = params(4)*exp(y(32)*(params(4)-1))*T(32)*y(74)+y(73)+T(36)*y(23)*(-(T(27)*(1-params(7))));
residual(15) = T(8)*y(82)+y(65)*(-(params(11)*T(12)*T(57)))+y(64)*(-(params(11)*T(58)*T(59)));
residual(16) = y(69)*(-exp(y(45)))+y(67)*(-(T(5)*T(19)*T(16)*T(61)))+y(66)*(-(T(17)*T(3)*T(16)*T(62)))+y(65)*(-(T(14)*params(11)*T(60)))+exp(y(45))*y(64)+params(32)*y(140)-y(94);
residual(17) = T(20)*y(69)+params(32)*y(117)*(-(T(69)*T(72)))+params(32)*y(118)*(-(T(73)*(T(65)*T(75)*T(76)+T(66)*T(75)*T(78))))+params(32)*y(119)*T(82)+params(32)*y(120)*(-(exp((1-params(3))*y(110))*exp(T(1)*y(114))*params(3)*exp(params(3)*y(46))))+params(32)*y(121)*(-(T(20)*(1-params(10))));
residual(18) = (T(41)-T(22))*T(86)+y(71)*(-(params(1)*T(86)/T(31)))+T(4)*y(70)+y(68)*T(88)+y(67)*T(92)+y(66)*T(94)+y(64)*(-(T(59)*T(96)))+params(32)*y(122)*(-((-(T(86)*T(98)))/(T(29)*T(29))));
residual(19) = (T(41)-T(22))*T(99)+y(71)*T(100)+exp(y(48))*y(69)+params(32)*y(122)*(-((-(T(98)*T(99)))/(T(29)*T(29))));
residual(20) = exp(y(49))*y(67)+T(101);
residual(21) = y(70)*(-(T(25)*T(102)))+exp(y(50))*y(66);
residual(22) = T(104);
residual(23) = y(83)+params(32)*y(129)*(-params(15))+y(68)*(-(exp(y(47)*(1-params(3)))*exp(y(13)*params(3))*T(1)*exp(T(1)*y(52))))+y(67)*(-(T(5)*T(19)*T(16)*T(105)))+y(66)*(-(T(17)*T(3)*T(16)*T(106)))+y(64)*(-(T(59)*T(108)))+T(109)*(-params(16))*y(141);
residual(24) = y(84)+params(32)*y(130)*(-params(18))+T(39)+y(74)*(-exp(y(53)))+T(109)*(-params(19))*y(142);
residual(25) = T(29)*(-T(22))+y(85)+params(32)*y(131)*(-params(21))+T(22)*y(69)+T(109)*(-params(22))*y(143);
residual(26) = y(86)+params(32)*y(132)*(-params(24))+T(110)+T(109)*(-params(25))*y(144);
residual(27) = T(29)*(-T(40))+y(87)+params(32)*y(133)*(-params(27))+T(23)*y(69)+T(109)*(-params(28))*y(145);
residual(28) = y(89);
residual(29) = y(90);
residual(30) = y(91);
residual(31) = y(92);
residual(32) = y(93);
residual(33) = y(94);
residual(34) = T(113)+exp(y(63))*y(88);
residual(35) = exp(y(45))-T(9)^T(10);
residual(36) = exp(y(30))-params(11)*T(12)*T(14);
residual(37) = exp(y(50))-T(3)*T(15)*T(16)*T(17);
residual(38) = exp(y(49))-T(5)*T(16)*T(18)*T(19);
residual(39) = exp(y(41))-exp(T(1)*y(52))*exp(y(13)*params(3))*exp(y(47)*(1-params(3)));
residual(40) = exp(y(48))+T(20)+T(21)+T(22)+T(23)+T(24)-(exp(y(45))+exp(y(13))*(1-params(10)));
residual(41) = T(4)-T(25)*exp(y(50))^T(26);
residual(42) = 1-exp(y(113))*(1+exp(y(112))-params(10));
residual(43) = T(27)-params(1)*T(29)/T(31);
residual(44) = y(42)-exp(y(113))*(exp(y(40))*exp(y(105))+(1-exp(y(40)))*y(106)-params(6)*exp(y(115))*exp(params(5)*y(40)));
residual(45) = y(43)-(y(42)*params(7)+exp(y(113))*(1-params(7))*y(107));
residual(46) = y(43)*params(4)*exp(y(32)*(params(4)-1))*T(32)-exp(y(53));
residual(47) = T(114);
residual(48) = exp(y(36))-(exp(y(7))*(1-exp(y(11)))+params(7)*exp(y(38)));
residual(49) = exp(y(35))-(exp(y(6))*(1-exp(y(10)))+params(7)*exp(y(37)));
residual(50) = exp(y(38))-((1-params(7))*exp(y(9))+T(32)*exp(y(32)*params(4)));
residual(51) = exp(y(37))-((1-params(7))*exp(y(8))+exp(y(31)*params(4))*T(34));
residual(52) = exp(y(34))-exp(y(7))*exp(y(11));
residual(53) = exp(y(33))-exp(y(6))*exp(y(10));
residual(54) = T(8)-(exp(y(34))+exp(y(33)));
residual(55) = y(52)-(x(it_, 5)+params(15)*y(16)+params(16)*y(25));
residual(56) = y(53)-(x(it_, 2)+params(18)*y(17)+params(19)*y(26));
residual(57) = y(54)-(x(it_, 1)+params(21)*y(18)+params(22)*y(27));
residual(58) = y(55)-(x(it_, 4)+params(24)*y(19)+params(25)*y(28));
residual(59) = y(56)-(x(it_, 3)+params(27)*y(20)+params(28)*y(29));
residual(60) = exp(y(63))-exp(y(10));
residual(61) = y(57)-(y(30)-y(1));
residual(62) = y(58)-(y(32)-y(3));
residual(63) = y(59)-(y(31)-y(2));
residual(64) = y(60)-(y(34)-y(5));
residual(65) = y(61)-(y(33)-y(4));
residual(66) = y(62)-(y(45)-y(12));
lhs = y(95);
rhs = y(129);
residual(67) = lhs - rhs;
lhs = y(96);
rhs = y(130);
residual(68) = lhs - rhs;
lhs = y(97);
rhs = y(131);
residual(69) = lhs - rhs;
lhs = y(98);
rhs = y(132);
residual(70) = lhs - rhs;
lhs = y(99);
rhs = y(133);
residual(71) = lhs - rhs;
lhs = y(100);
rhs = y(16);
residual(72) = lhs - rhs;
lhs = y(101);
rhs = y(17);
residual(73) = lhs - rhs;
lhs = y(102);
rhs = y(18);
residual(74) = lhs - rhs;
lhs = y(103);
rhs = y(19);
residual(75) = lhs - rhs;
lhs = y(104);
rhs = y(20);
residual(76) = lhs - rhs;

end
